import request from '@/utils/request'
import { BASE_API } from '@/api/baseUrl'

/**
 * 月度计划编制
 * 根据id查询月度计划申请
 * @param {*} params
 */
export function apiMonthplanFindById({ id }) {
  return request({
    url: BASE_API() + '/monthplan/findById?id=' + id,
    method: 'post'
  })
}

/**
 * 发货计划导出表单到excel
 * @param {*} params
 */
export function apiExportMonthPlanOrder(data) {
  return request({
    url: BASE_API() + `/monthplan/exportMonthPlanOrder`,
    method: 'get',
    params: data
  })
}

/**
 * 月度计划编制
 * 根据id查询月计划发货申请
 * @param {*} params
 */
export function apiMonthplanAdjustFindById(data) {
  return request({
    url: BASE_API() + '/monthplanadjuseimport/findById',
    method: 'post',
    params: data
  })
}

/**
 * 发货计划调整导出表单到excel
 * @param {*} params
 */
export function apiExportMonthPlanAdjuseOrder(data) {
  return request({
    url: BASE_API() + `/monthplanadjuse/exportMonthPlanAdjuseOrder`,
    method: 'get',
    params: data
  })
}

/**
 * 月度计划编制
 * 创建要货申请-根据id查询要货申请
 * @param {*} params
 */
export function apiWantgoodsFindById({ id }) {
  return request({
    url: BASE_API() + '/wantgoods/findById?id=' + id,
    method: 'post'
  })
}
