import { login, logout } from '@/api/login'
import { resetRouter } from '@/router'
import { setToken, clearToken } from '@/utils/auth'

const actions = {
  // user login
  login({ commit }, userInfo) {
    const { username, password } = userInfo
    return new Promise((resolve, reject) => {
      login({ userName: username.trim(), password: password })
        .then(response => {
          const { data, status } = response
          if (status !== 200) {
            // Message.error('登录失败，请验证账号名和密码')
            return
          }
          commit('SET_TOKEN', data)
          setToken(data)
          resolve()
        })
        .catch(error => {
          reject(error)
        })
    })
  },
  outlogin({ commit }, token) {
    if (token !== null) {
      commit('SET_TOKEN', token)
      setToken(token)
    }
  },

  // user logout
  logout({ commit, state }) {
    return new Promise((resolve, reject) => {
      logout(state.token)
        .then(() => {
          commit('SET_TOKEN', '')
          clearToken()
          resetRouter()

          resolve()
        })
        .catch(error => {
          reject(error)
        })
    })
  },

  // remove token
  resetToken({ commit }) {
    return new Promise(resolve => {
      commit('SET_TOKEN', '')
      clearToken()
      resolve()
    })
  },

  setToken({ commit }, token) {
    return new Promise(resolve => {
      commit('SET_TOKEN', token)
      setToken(token)
      resolve()
    })
  },

  // dynamically modify permissions
  changeRoles({ commit }, role) {
    return new Promise(resolve => {
      const token = role + '-token'
      commit('SET_TOKEN', token)
      setToken(token)
      resolve()
    })
  }
}

export default actions
