// webpack.config.js
const path = require('path')

module.exports = {
  publicPath: process.env.NODE_ENV === 'production' ? '/qywx/' : '',
  css: {
    loaderOptions: {
      sass: {
        // 全局引入变量和 mixin
        additionalData: `
              @import "@/assets/styles/variable.scss";
              @import "@/assets/styles/mixin.scss";
            `
      }
    }
  },
  devServer: {
    proxy: {
      '/huigou': {
        target: 'http://10.0.135.139',
        // target: 'http://10.2.7.85',
        changeOrigin: true,
        pathRewrite: {
          '^/huigou': '/crm-app' // 重写,
        }
      }
    }
  },
  productionSourceMap: false,
  configureWebpack: {
    resolve: {
      alias: {
        '@': path.resolve(__dirname, './src'),
        '@img': path.resolve(__dirname, './src/assets/images')
      }
    },
    plugins: []
  }
}
