// 判断是什么设备
export const isH5OrPc = () => {
  if (/Mobile|Android|webOS|iPhone|iPad|Phone/i.test(navigator.userAgent)) {
    return 'H5'
  }
  return 'PC'
}

/**
 * @param {string} url
 * @returns {Object}
 */
export function getQueryObject(url) {
  url = url == null ? window.location.href : url
  const search = url.substring(url.lastIndexOf('?') + 1)
  const obj = {}
  const reg = /([^?&=]+)=([^?&=]*)/g
  search.replace(reg, (rs, $1, $2) => {
    const name = decodeURIComponent($1)
    let val = decodeURIComponent($2)
    val = String(val)
    obj[name] = val
    return rs
  })
  return obj
}
