/* eslint-disable space-before-function-paren */
import router from './router'
// import store from './store'
import { getToken } from '@/utils/auth' // get token from cookie
// import { login } from '@/api/login'

// 过滤器白名单
const whiteList = ['', ''] // no redirect whitelist

router.beforeEach(async (to, from, next) => {
  // console.log('to---', to)
  if (to.meta.title) {
    document.title = to.meta.title
  }

  const hasToken = getToken()

  if (hasToken) {
    next()
  } else {
    if (to.query?.taskToken) {
      // login({ ...to.query })
      //   .then(async res => {
      //     if (res.status) {
      //       await store.dispatch('setToken', res.data.token)
      //       store.commit('SET_USERINFO', res.data.operator || {})
      //       next()
      //     } else {
      //       next('/login')
      //     }
      //   })
      //   .catch(() => {
      //     next('/login')
      //   })
      next()
    } else {
      if (whiteList.indexOf(to.path) !== -1) {
        next('/login')
      } else {
        next('/login?redirect=${to.path}')
        // return `/login?redirect=${to.path}`
      }
    }
  }
})
