import { reactive } from 'vue'

const mergeState = (state, payload) => {
  const stateR = reactive({
    state
  })
  Object.keys(payload).forEach(key => {
    if (!{}.hasOwnProperty.call(payload, key)) return
    if (typeof stateR[key] === 'undefined') {
      stateR[key] = payload[key]
      return
    }
    stateR[key] = payload[key]
  })
  return stateR
}

const mutations = {
  replaceState(state, payload) {
    mergeState(state, payload)
  },
  startLoading(state) {
    state.isLoading = true
  },
  closeLoading(state) {
    state.isLoading = false
  },
  startUpload(state) {
    state.isUploading = true
    state.uploadPercent = 0
  },
  uploadProgress(state, percent) {
    state.uploadPercent = percent
  },
  endUpload(state) {
    state.isUploading = false
    state.uploadPercent = 0
  },
  SET_USERINFO(state, userInfo) {
    state.userInfo = userInfo
  },
  SET_TOKEN: (state, token) => {
    state.token = token
  }
}

export default mutations
