// webpack.config.js
const path = require('path')

module.exports = {
  css: {
    loaderOptions: {
      sass: {
        // 全局引入变量和 mixin
        additionalData: `
              @import "@/assets/styles/variable.scss";
              @import "@/assets/styles/mixin.scss";
            `
      }
    }
  },
  devServer: {},
  productionSourceMap: false,
  configureWebpack: {
    resolve: {
      alias: {
        '@': path.resolve(__dirname, './src'),
        '@img': path.resolve(__dirname, './src/assets/images')
      }
    },
    plugins: []
  }
}
