import { createApp } from 'vue'

import store from './store'
import router from './router'
import './assets/styles/reset.css'
import App from './App.vue'

import {
  Button,
  NavBar,
  Cell,
  Step,
  Steps,
  Collapse,
  CollapseItem,
  Field,
  CellGroup,
  Picker,
  Popup
} from 'vant'

const app = createApp(App)
app.use(store)
app.use(router)
app
  .use(Button)
  .use(NavBar)
  .use(Cell)
  .use(Step)
  .use(Steps)
  .use(Collapse)
  .use(CollapseItem)
  .use(Field)
  .use(CellGroup)
  .use(Picker)
  .use(Popup)

app.mount('#app')
