import axios from 'axios'
const formHeader = {
  'Content-Type': 'application/x-www-form-urlencoded;charset=UTF-8'
}

/**
 * 获取颜色列表
 * @param params 
 * @returns 
 */
export const getColorsList = (params: any) => {
  return axios.get('/api/color/page', {
    params,
    headers: formHeader
  })
}

/**
 * 新增颜色
 * @param data 
 * @returns 
 */
export const saveColor = (data: any) => {
  return axios.post('/api/color/add', data)
}

/**
 * 修改颜色
 * @param data 
 * @returns 
 */
export const modifyColor = (data: any) => {
  return axios.post('/api/color/edit', data)
}

/**
 * 批量删除颜色
 * @param ids 
 * @returns 
 */
export const deleteColors = (ids: any) => {
  return axios.get('/api/color/batchDeleteByIds', {
    params: { ids },
    headers: formHeader
  })
}
