import { createRouter, createWebHistory } from 'vue-router'
import Layout from '@/layout/LayoutView.vue'
import type { App } from 'vue'
import { useUserStore } from '@/stores/user'

const baseRoutes = [
  {
    path: '/',
    name: 'Root',
    redirect: '/order/list'
  }
]

export const routes = [
  // {
  //   path: '/home',
  //   component: Layout,
  //   hiddenChild: true,
  //   meta: {
  //     title: '首页'
  //   },
  //   children: [
  //     {
  //       path: '',
  //       name: 'Home',
  //       component: () => import('@/views/home/HomeView.vue')
  //     }
  //   ]
  // },
  {
    path: '/order',
    name: 'Order',
    component: Layout,
    meta: {
      title: '订单管理'
    },
    children: [
      {
        path: '/order/scripts',
        name: 'OrderScripts',
        component: () => import('@/views/order/scripts/index.vue'),
        meta: {
          title: '脚本管理'
        }
      },
      {
        path: '/order/list',
        name: 'OrderList',
        component: () => import('@/views/order/orderList/OrderList.vue'),
        meta: {
          title: '订单文件'
        }
      },
      {
        path: '/order/change',
        name: 'OrderChange',
        component: () => import('@/views/order/orderChange/OrderChange.vue'),
        meta: {
          title: '订单转换'
        }
      },
      {
        path: '/order/conver',
        name: 'OrderConver',
        component: () => import('@/views/order/convertOrder/index.vue'),
        meta: {
          title: '转换记录'
        }
      },
      {
        path: '/order/customer',
        name: 'OrderCustomer',
        component: () => import('@/views/customer/CustomerList/CustomerList.vue'),
        meta: { title: '客户管理' }
      },
      {
        path: '/order/customer-email',
        name: 'OrderCustomerEmail',
        component: () => import('@/views/customer/CustomerEmail/CustomerEmail.vue'),
        meta: { title: '客户邮箱' }
      },
      {
        path: '/order/responsible-customer',
        name: 'ResponsibleCustomer',
        component: () => import('@/views/customer/ResponsibleCustomer/ResponsibleCustomer.vue'),
        meta: { title: '负责客户' }
      }
    ]
  },
  {
    path: '/email',
    name: 'Email',
    redirect: '/email/list',
    component: Layout,
    meta: {
      title: '邮件管理'
    },
    children: [
      {
        path: '/email/list',
        name: 'EmailList',
        component: () => import('@/views/email/EmailView.vue'),
        meta: {
          title: '邮件列表'
        }
      }
    ]
  },
  // {
  //   path: '/configure',
  //   name: 'Configure',
  //   component: Layout,
  //   meta: {
  //     title: '配置管理'
  //   },
  //   children: [
  //     // {
  //     //   path: '/configure/color',
  //     //   name: 'ConfigureColor',
  //     //   component: () => import('@/views/configure/colors/ConfigureColor.vue'),
  //     //   meta: {
  //     //     title: '颜色管理'
  //     //   }
  //     // },
  //     {
  //       path: '/configure/factory',
  //       name: 'ConfigureFactory',
  //       component: () => import('@/views/configure/factory/ConfigureFactory.vue'),
  //       meta: {
  //         title: '工厂管理'
  //       }
  //     },
  //     {
  //       path: '/configure/brand',
  //       name: 'ConfigureBrand',
  //       component: () => import('@/views/configure/brand/ConfigureBrand.vue'),
  //       meta: {
  //         title: '品牌管理'
  //       }
  //     }
  //   ]
  // },
  {
    path: '/product',
    name: 'Product',
    component: Layout,
    meta: {
      title: '产品管理'
    },
    children: [
      {
        path: '/product/list',
        name: 'ProductList',
        component: () => import('@/views/product/productList/ProductList.vue'),
        meta: {
          title: '产品列表'
        }
      },
      {
        path: '/product/compare',
        name: 'ProductCompare',
        component: () => import('@/views/product/productCompare/ProductCompare.vue'),
        meta: {
          title: '产品对照'
        }
      }
    ]
  },
  {
    path: '/online-excel',
    name: 'OnlineExcel',
    hidden: true,
    meta: {
      title: '订单上传'
    },
    component: () => import('@/views/excel/OnlineExcel2.vue')
  },
  {
    path: '/comment-excel',
    name: 'CommentExcel',
    hidden: true,
    meta: {
      title: '订单文件标注'
    },
    component: () => import('@/views/comment-excel/CommentExcel.vue')
  },
  {
    path: '/comment-upload',
    name: 'CommentUpload',
    meta: {
      title: '订单上传'
    },
    component: () => import('@/views/comment-excel/CommentUpload.vue')
  },
  {
    path: '/preview-excel',
    name: 'PreviewExcel',
    hidden: true,
    meta: {
      title: '预览'
    },
    component: () => import('@/views/order/preview/index.vue')
  }
]

const router = createRouter({
  history: createWebHistory(import.meta.env.BASE_URL),
  routes: [...baseRoutes, ...routes]
})

router.beforeEach((to, from, next) => {
  if (to.query.userId) {
    const userStore = useUserStore()
    userStore.setUserInfo(to.query.userId)

    next({
      replace: true,
      path: to.path
    })
  }

  next()
})

export function setupRouter(app: App) {
  app.use(router)
}

export default router
