import axios from 'axios'
const formHeader = {
  'Content-Type': 'application/x-www-form-urlencoded;charset=UTF-8'
}

/**
 * 获取工厂列表
 * @param params 
 * @returns 
 */
export const getFactoryList = (params: any) => {
  return axios.get('/api/factory/page', {
    params,
    headers: formHeader
  })
}

/**
 * 新增工厂
 * @param data 
 * @returns 
 */
export const saveFactory = (data: any) => {
  return axios.post('/api/factory/add', data)
}

/**
 * 修改工厂
 * @param data 
 * @returns 
 */
export const modifyFactory = (data: any) => {
  return axios.post('/api/factory/edit', data)
}

/**
 * 批量删除工厂
 * @param ids 
 * @returns 
 */
export const deleteFactorys = (ids: any) => {
  return axios.get('/api/factory/batchDeleteByIds', {
    params: { ids },
    headers: formHeader
  })
}
