import axios from 'axios'
const formHeader = {
  'Content-Type': 'application/x-www-form-urlencoded;charset=UTF-8'
}

/**
 * 获取品牌列表
 * @param params 
 * @returns 
 */
export const getBrandsList = (params: any) => {
  return axios.get('/api/brand/page', {
    params,
    headers: formHeader
  })
}

/**
 * 新增品牌
 * @param data 
 * @returns 
 */
export const saveBrand = (data: any) => {
  return axios.post('/api/brand/add', data)
}

/**
 * 修改品牌
 * @param data 
 * @returns 
 */
export const modifyBrand = (data: any) => {
  return axios.post('/api/brand/edit', data)
}

/**
 * 批量删除品牌
 * @param ids 
 * @returns 
 */
export const deleteBrands = (ids: any) => {
  return axios.get('/api/brand/batchDeleteByIds', {
    params: { ids },
    headers: formHeader
  })
}
