import axios from '@/utils/http'

const formHeader = {
  'Content-Type': 'application/x-www-form-urlencoded;charset=UTF-8'
}

/**
 * 根据id查询码表及明细表
 * @param dictCode
 * @returns
 */
export const apiDictFindById = (dictCode: string) => {
  return axios.get('/api/dict/findDictItemsByDictCode', {
    params: { dictCode },
    headers: formHeader
  })
}

/**
 * 获取码表分组
 * @param params 
 * @returns 
 */
export const apiDictList = (params: any) => {
  return axios.get('/api/dict/list', {
    params,
    headers: formHeader
  })
}
