import './assets/main.css'
import './assets/tailwind.css'
import 'element-plus/dist/index.css'
import 'vxe-table/lib/style.css'

import { createApp } from 'vue'

import App from './App.vue'
import ElementPlus from 'element-plus'
import VxeTable,{VXETable} from 'vxe-table'

import { setupRouter } from './router'
import { setupStore } from './stores'
import { zhCn } from 'element-plus/es/locales.mjs'


function bootstrap() {
  const app = createApp(App)

  setupStore(app)

  setupRouter(app)

  app.use(ElementPlus, {locale: zhCn})

  VXETable.config({
    table: {
      columnConfig: {
        resizable: true
      },
      rowConfig: {
        isHover: true,
        isCurrent: true,
      }
    }
  })

  app.use(VxeTable)

  app.mount('#app')
}

bootstrap()
