import { computed, reactive, toRefs } from 'vue'
import { ElMessage } from 'element-plus'
export function useOrderChangeCopy(api, beforePaste) {
  const state = reactive({
    // 复制信息
    copyInfo: []
  })

  // 是否复制
  const isCopying = computed(() => !!state.copyInfo.length)

  // 复制
  const handleCopy = (info) => {
    if (!info?.length) {
        return ElMessage.warning('没有可以复制的配置！')
    }
    state.copyInfo = JSON.parse(JSON.stringify(info))
    ElMessage.success('复制成功！')
  }

  return {
    ...toRefs(state),
    isCopying,
    handleCopy,
  }
}
