import { nextTick, unref } from 'vue'

export const useLuckysheetMark = () => {
  /**
   * 根据当前sheet页已有的标记，设置标记
   * @param {Object} marks 当前页所有的标记记录
   */
  function setSheetMarks(marks: any) {
    Object.values(marks).forEach((mark: any) => {
      addMark(mark)
    })
  }

  function addMark(mark: any) {
    window.luckysheet.sheetPostil.newArrow(mark.rowNum, mark.columNum, mark.filed.fliedTitle)
  }

  // 删除某一个mark
  function removeMark(mark: any) {
    const { r, c, columNum, rowNum } = unref(mark)
    window.luckysheet.sheetPostil.delPs(r || rowNum, c || columNum)
  }

  return {
    addMark,
    removeMark,
    setSheetMarks
  }
}
