import axios from '@/utils/http'

const formHeader = {
  'Content-Type': 'application/x-www-form-urlencoded;charset=UTF-8'
}

/**
 * 文件上传
 * @param {FormData} file 文件信息
 * @returns
 */
export const uploadFile = (file: any) => {
  return axios.post('/api/excel/upload', file, {
    headers: {
      'Content-Type': 'multipart/form-data'
    }
  })
}

/**
 * 上传文件确认，多文件合并
 * @param {Object} data
 * @returns
 */
export const apiSaveUpload = (data: any) => {
  return axios.post('/api/excel/saveUpload', data)
}

/**
 * 设置产品标记
 * @param {Object} data
 * @returns
 */
export const saveProductMark = (data: any) => {
  return axios.post('/api/excel/saveProductMark', data)
}

/**
 * 保存标记
 * @param {Object} data
 * @returns
 */
export const apiSaveMark = (data: any) => {
  return axios.post('/api/excel/saveMark', data)
}

/**
 * 设置excel订单循环体开始标记
 * @param data
 * @returns
 */
export const saveExcelOrderIndex = (data: any) => {
  return axios.post('/api/excel/saveExcelOrderIndex', data)
}

/**
 * 根据文件IDexcel订单循环体开始标记
 * @param fileId
 * @returns
 */
export const getExcelOrderIndex = (fileId: string) => {
  return axios.get('/api/excel/getExcelOrderIndex', {
    params: {
      fileId
    },
    headers: formHeader
  })
}

/**
 * 根据产品编号获取可变字段
 * @param {String} productCode
 * @returns
 */
export const getVariableField = (excelOrderId: any) => {
  return axios.get('/api/excel/variableField', {
    params: { excelOrderId },
    headers: formHeader
  })
}

/**
 * 根据文件ID执行解析
 * @param {String} fileId 文件Id
 * @returns
 */
export const apiToDo = (fileId: any) => {
  return axios.get('/api/excel/todo', {
    params: { fileId },
    headers: formHeader
  })
}

/**
 * 获取所有的脚本列表
 * @returns
 */
export const apiGetScript = () => {
  return axios.get('/api/excel/scripts', {
    headers: formHeader
  })
}

/**
 * 获取所有系统支持的订单字段
 * @returns
 */
export const apiGetOrderField = () => {
  return axios.get('/api/excel/orderFields', { headers: formHeader })
}

/**
 * 根据文件ID获取产品标记列表
 * @param {String} fileId 文件Id
 * @returns
 */
export const getProductMark = (fileId: any) => {
  return axios.get('/api/excel/getProductMarks', {
    params: { fileId },
    headers: formHeader
  })
}

/**
 * 根据文件ID获取标记
 * @param {String} fileId 文件Id
 * @returns
 */
export const apiGetMark = (fileId: any) => {
  return axios.get('/api/excel/getMarks', {
    params: { fileId },
    headers: formHeader
  })
}

/**
 * 获取客户产品列表
 * @param {String} customerId
 * @returns
 */
export const getCustomerProductList = (customerId: string) => {
  return axios.get('/api/excel/getCustomerProductList', {
    params: { customerId },
    headers: formHeader
  })
}

/**
 * 清除标记
 * @param {String} filedConfId 单元格id
 * @returns
 */
export const apiDeleteMark = (filedConfId: any) => {
  return axios.get('/api/excel/deleteMark', {
    params: { filedConfId },
    headers: formHeader
  })
}

/**
 * 根据文件ID清除所有标记
 * @param {String} fileId 文件id
 * @returns
 */
export const apiClearMark = (fileId: any) => {
  return axios.get('/api/excel/clearMark', {
    params: { fileId },
    headers: formHeader
  })
}

export const addExcelArea = (data: any) => {
  return axios.post('/api/excelMark/addExcelArea', data)
}
export const batchAddExcelArea = (data: any) => {
  return axios.post('/api/excelMark/batchAddExcelArea', data)
}
export const editExcelArea = (data: any) => {
  return axios.post('/api/excelMark/editExcelArea', data)
}

export const getExcelAreaByFileId = (orderFileId: string) => {
  return axios.get('/api/excelMark/getExcelAreaByFileID', {
    params: { orderFileId },
    headers: formHeader
  })
}
export const removeExcelArea = (excelAreaId: string) => {
  return axios.get('/api/excelMark/removeExcelArea', {
    params: { excelAreaId },
    headers: formHeader
  })
}
export const getExcelConnectByFileId = (orderFileId: string) => {
  return axios.get('/api/excelMark/getExcelAreaConnectByFileID', {
    params: { orderFileId },
    headers: formHeader
  })
}
export const removeExcelAreaConnect = (excelAreaConnectId: string) => {
  return axios.get('/api/excelMark/removeExcelAreaConnect', {
    params: { excelAreaConnectId },
    headers: formHeader
  })
}
export const addExcelAreaConnect = (data: any) => {
  return axios.post('/api/excelMark/addExcelAreaConnect', data)
}
export const excelMarkRun = (orderFileId: string) => {
  return axios.get('/api/excelMark/run', {
    params: {
      orderFileId
    },
    headers: formHeader
  })
}
