import axios from "@/utils/http";

const formHeader = {
  'Content-Type': 'application/x-www-form-urlencoded;charset=UTF-8'
}


/**获取订单变量文件 */
export const getVarOrderFilePage = (params: any) => {
  return axios.get('/api/orderVar/pageVarOrderFile', {
    params,
    headers: formHeader
  })
}

/**获取变量文件 */
export const getVarFilePage = (params: any) => {
  return axios.get('/api/varFile/page', {
    params,
    headers: formHeader
  })
}

export const getOrderFileById = (id: string) => {
  return axios.get('/api/varFile/getById', {
    params: { id },
    headers: formHeader
  })
}

/**
 * 解析的变量结果
 * @param data
 * @returns
 */
export const apiVarTemplatePage = (data: any) => {
  return axios.get("/api/varTemplateDetail/page", {
    params: data,
  });
};

/**
 * 设置变量字段
 * @param data
 * @returns
 */
export const apiVarTemplateSaveConf = (data: any) => {
  return axios.post("/api/varTemplateDetail/saveConf", data);
};

/**
 * 根据标量模板文件ID获取未转换的变量
 * @param varTemplateDetailId 
 * @returns 
 */
export const apiVarTemplateGetVars = (varTemplateDetailId: any) => {
  return axios.get("/api/varTemplateDetail/getVars", {
    params: { varTemplateDetailId },
  });
};

/**
 * 根据标量模板文件ID获取转换后变量
 * @param varTemplateDetailId 
 * @returns 
 */
export const apiVarTemplateGetNewVars = (varTemplateDetailId: any) => {
  return axios.get("/api/varTemplateDetail/getNewVars", {
    params: { varTemplateDetailId },
  });
};
/**
 * 模板变量ID获取字段配置
 * @param varTemplateDetailId 
 * @returns 
 */
export const apiVarTemplateGetConf = (varTemplateDetailId: any) => {
  return axios.get("/api/varTemplateDetail/getConfByVarTemplateDetailId", {
    params: { varTemplateDetailId },
  });
};

/**
 * 转换变量
 * @param varTemplateDetailId 
 * @returns 
 */
export const apiVarTemplateConvert = (varTemplateDetailId: any) => {
  return axios.get("/api/varTemplateDetail/convert", {
    params: { varTemplateDetailId },
  });
};

/**
 * 订单项次列表
 * @param  params
 * @returns 
 */
export const apiOrderVarPage = (params: any) => {
  return axios.get("/api/orderVar/page", {
    params,
  });
};

/**
 * 上传变量文件确认，多文件合并
 * @param  data
 * @returns 
 */
export const apiOrderVarSaveUpload = (data: any) => {
  return axios.post("/api/orderVar/saveUpload", data);
};

/**
 * 执行变量文件解析
 * @param  orderItemId
 * @returns 
 */
export const apiOrderVarRun = (orderItemId: any) => {
  return axios.get("/api/orderVar/run", {
    params: { orderItemId }
  });
};

/**
 * 根据标量模板文件ID获取未转换的变量
 * @param  orderItemId
 * @returns 
 */
export const apiOrderVarGetVars = (orderItemId: any) => {
  return axios.get("/api/orderVar/getVars", {
    params: { orderItemId }
  });
};

/**
 * 根据标量模板文件ID获取转换后变量
 * @param  orderItemId
 * @returns 
 */
export const apiOrderVarGetNewVars = (orderItemId: any) => {
  return axios.get("/api/orderVar/getNewVars", {
    params: { orderItemId }
  });
};

/**
 * 根据标量模板文件ID获取转换后变量
 * @param  orderItemId
 * @returns 
 */
export const apiOrderVarGetOrderNewVars = (orderItemId: any) => {
  return axios.get("/api/orderVar/getOrderNewVars", {
    params: { orderItemId }
  });
};

/**
 * 获取变量下拉数据
 * @param  orderItemId
 * @returns 
 */
export const getVarSpecList = (productCode: any) => {
  return axios.get("/api/varTemplateDetail/getVarSpecList", {
    params: { productCode }
  });
};

/**
 * 获取过滤映射字段
 * @param  orderItemId
 * @returns 
 */
export const getFilterMapField = () => {
  return axios.get("/api/completeOrder/getClassFiledsList");
};


/**
 * checkOrder
 * @param  orderItemId
 * @returns 
 */
export const getCheckOrder = (orderItemId: any) => {
  return axios.get("/api/orderVar/checkOrder", {
    params: { orderItemId }
  });
};


