import axios from '@/utils/http'

const formHeader = {
  'Content-Type': 'application/x-www-form-urlencoded;charset=UTF-8'
}

/**
 * 根据id查询码表及明细表
 * @param dictCode
 * @returns
 */
export const apiDictFindById = (dictCode: string) => {
  return axios.get('/api/dict/findDictItemsByDictCode', {
    params: { dictCode },
    headers: formHeader
  })
}

/**
 * 获取码表分组
 * @param params 
 * @returns 
 */
export const apiDictList = (params: any) => {
  return axios.get('/api/dict/list', {
    params,
    headers: formHeader
  })
}

/**
 * 变量模块内置变量
 * @param params 
 * @returns 
 */
export const apiOrderVarGetVarField = () => {
  return axios.get('/api/orderVar/getVarField')
}

/**
 * 帮助脚本
 * @param params 
 * @returns 
 */
export const apiGetScriptDesc = () => {
  return axios.get('/api/exlScript/getScriptDesc')
}
