import type { Recordable } from '@/types/global'
import { ElMessage } from 'element-plus'
import { defineStore } from 'pinia'

type StoreState = {
  fileInfo: Recordable,
  copyFileId: undefined | string
}
export const useCommentExcel = defineStore('CommentExcel', {
  state: (): StoreState => ({
    fileInfo: {},
    copyFileId: undefined
  }),
  getters: {
    getFileInfo(): Recordable {
      return this.fileInfo
    },
    isSameFile(): boolean {
      return this.fileInfo?.orderFileId === this.copyFileId
    },
    isSameVarFile(): boolean {
      return this.fileInfo?.varFileId === this.copyFileId
    }
  },
  actions: {
    setFileInfo(data: any) {
      this.fileInfo = data
    },
    setCopyFileId() {
      if (!this.fileInfo?.orderFileId || this.fileInfo?.varFileId) {
        return ElMessage('请选择正确的复制对象！')
      }
      this.copyFileId = this.fileInfo?.orderFileId || this.fileInfo?.varFileId
    }
  }
})
