import axios from '@/utils/http'
const formHeader = {
  'Content-Type': 'application/x-www-form-urlencoded;charset=UTF-8'
}

/**
 * 脚本列表
 * @param params
 * @returns
 */
export const getExcelScripts = (params: any) => {
  return axios.get('/api/exlScript/page', {
    params,
    headers: formHeader
  })
}

/**
 * 新增脚本
 * @param data
 * @returns
 */
export const addExcelScripts = (data: any) => {
  return axios.post('/api/exlScript/add', data)
}

/**
 * 修改脚本
 * @param data
 * @returns
 */
export const editExcelScripts = (data: any) => {
  return axios.post('/api/exlScript/edit', data)
}

/**
 * 批量删除脚本
 * @param ids
 * @returns
 */
export const deleteExcelScripts = (ids: any) => {
  return axios.get('/api/exlScript/batchDeleteByIds', {
    params: { ids },
    headers: formHeader
  })
}

/**
 * 测试脚本
 * @param params
 * @returns
 */
export const testExcelScripts = (data: any) => {
  return axios.post('/api/exlScript/testScript', data)
}
