import axios, { type InternalAxiosRequestConfig } from 'axios'
import { useUserStore } from '@/stores/user'
import { ElMessage } from "element-plus";


const service = axios.create()


service.interceptors.request.use((config) => {
    const userStore = useUserStore()
    if (userStore.getUserInfo) {
        config.headers.set('Userid', userStore.getUserInfo)
    }
    return config
})



//第三步:响应拦截器
service.interceptors.response.use((response) => {
     //成功回调
     //简化数据
     return response;
}, (error) => {
     //失败回调:处理http网络错误的
     //定义一个变量:存储网络错误信息
     let message = '';
     //http状态码
     let status = error.response.status;
     switch (status) {
          case 401:
               message = "TOKEN过期"
               break;
          case 403:
               message = "无权访问"
               break;
          case 404:
               message = "请求地址错误";
               break;
          case 500:
               message = "服务器出现问题"
               break;
          case 504:
               message = "请求超时"
               break;
          default:
               message = "网络出现问题";
               break;
     }
     //提示错误信息
     ElMessage({
          type: 'error',
          message
     });
     return Promise.reject(error);
});



export default service