import axios from '@/utils/http'

const formHeader = {
  'Content-Type': 'application/x-www-form-urlencoded;charset=UTF-8'
}

/**
 * 获取客户列表
 * @param params
 * @returns
 */
export const getCustomerPage = (params: any) => {
  return axios.get('/api/customer/page', {
    params,
    headers: formHeader
  })
}

/**
 * 获取用户负责客户列表
 * @param params
 * @returns
 */
export const getUserOrderFileConfPage = (params: any) => {
  return axios.get('/api/userOrderFileConf/page', {
    params,
    headers: formHeader
  })
}

/**
 * 批量删除用户负责客户
 * @param params
 * @returns
 */
export const deleteUserOrderFileConfByIds = (ids: string) => {
  return axios.get('/api/userOrderFileConf/batchDeleteByIds', {
    params: { ids },
    headers: formHeader
  })
}

/**
 * 添加用户负责客户
 * @param data
 * @returns
 */
export const addUserOrderFileConf = (data: any) => {
  return axios.post('/api/userOrderFileConf/add', data)
}

/**
 * 修改用户负责客户
 * @param data
 * @returns
 */
export const editUserOrderFileConf = (data: any) => {
  return axios.post('/api/userOrderFileConf/edit', data)
}

/**
 * 获取用户
 * @param data
 * @returns
 */
export const getUserList = (params: any) => {
  return axios.get('/api/sysUser/page', {
    params,
    headers: formHeader
  })
}


/**
 * 获取资料库类型列表
 * @param params
 * @returns
 */
export const getInformationTypeListApi = (params: any) => {
  return axios.get('/api/information/typePage', {
    params,
    headers: formHeader
  })
}

/**
 * 获取资料库title
 * @param params
 * @returns
 */
export const getInformationListTitlesApi = (params: any) => {
  return axios.get('/api/information/listInformationTitles', {
    params,
    headers: formHeader
  })
}

// /**
//  * 获取资料库列表数据
//  * @param params
//  * @returns
//  */
// export const getInformationListApi = (data: any) => {
//   return axios.post('/api/information/listInformation', data)
// }

/**
 * 获取资料库列表数据
 * @param params
 * @returns
 */
export const getInformationListApi = (data: any) => {
  return axios.post('/api/information/pageInformation', data)
}



/**
 * 导入客户资料
 * @param params
 * @returns
 */
export const importInformationApi = (data: any) => {
  return axios.post('/api/information/loadInformation', data)
}

/**
 * 新增资料库列表数据
 * @param params
 * @returns
 */
export const addInformationInfoApi = (data: any) => {
  return axios.post('/api/information/add', data)
}

/**
 * 修改资料库列表数据
 * @param params
 * @returns
 */
export const updateInformationInfoApi = (data: any) => {
  return axios.post('/api/information/updateByID', data)
}

/**
 * 删除资料库列表数据
 * @param params
 * @returns
 */
export const delInformationInfoApi = (params: any) => {
  return axios.get('/api/information/deleteByID', {
    params,
    headers: formHeader
  })
}


/**
 * 删除资源库
 * @param params
 * @returns
 */
export const deleteInformation = (params: any) => {
  return axios.get('/api/information/deleteInformation', {
    params,
    headers: formHeader
  })
}
