import axios, { type InternalAxiosRequestConfig } from 'axios'
import { useUserStore } from '@/stores/user'

const service = axios.create()


service.interceptors.request.use((config) => {
    const userStore = useUserStore()
    if (userStore.getUserInfo) {
        config.headers.set('Userid', userStore.getUserInfo)
    }
    return config
})


export default service