import { createRouter, createWebHistory } from 'vue-router'
import Layout from '@/layout/LayoutView.vue'
import type { App } from 'vue'
import { useUserStore } from '@/stores/user'

const baseRoutes = [
  {
    path: '/',
    name: 'Root',
    redirect: '/order/list'
  }
]

export const routes = [
  {
    path: '/order',
    name: 'Order',
    component: Layout,
    meta: {
      title: '订单管理'
    },
    children: [
      {
        path: '/order/scripts',
        name: 'OrderScripts',
        component: () => import('@/views/order/scripts/index.vue'),
        meta: {
          title: '脚本管理'
        }
      },
      {
        path: '/order/scripts-help',
        name: 'OrderScriptsHelp',
        hidden: true,
        component: () => import('@/views/order/scripts/help.vue'),
        meta: {
          title: '帮助文档'
        }
      },
      {
        path: '/order/list',
        name: 'OrderList',
        component: () => import('@/views/order/orderList/OrderList.vue'),
        meta: {
          title: '订单文件'
        }
      },
      {
        path: '/order/temp',
        name: 'OrderTemp',
        component: () => import('@/views/order/orderList/OrderTempList.vue'),
        meta: {
          title: '模版文件'
        }
      },
      {
        path: '/order/change',
        name: 'OrderChange',
        component: () => import('@/views/order/orderChange/OrderChange.vue'),
        meta: {
          title: '订单转换'
        }
      },
      {
        path: '/order/conver',
        name: 'OrderConver',
        component: () => import('@/views/order/convertOrder/index.vue'),
        meta: {
          title: '转换记录'
        }
      },
      {
        path: '/order/customer',
        name: 'OrderCustomer',
        component: () => import('@/views/customer/CustomerList/CustomerList.vue'),
        meta: { title: '客户管理' }
      },
      {
        path: '/order/customer-email',
        name: 'OrderCustomerEmail',
        component: () => import('@/views/customer/CustomerEmail/CustomerEmail.vue'),
        meta: { title: '客户邮箱' }
      },
      {
        path: '/order/responsible-customer',
        name: 'ResponsibleCustomer',
        component: () => import('@/views/customer/ResponsibleCustomer/ResponsibleCustomer.vue'),
        meta: { title: '负责客户' }
      }
    ]
  },
  {
    path: '/variables',
    name: 'Variables',
    component: Layout,
    meta: {
      title: '变量管理'
    },
    children: [
      {
        path: '/variables/file',
        name: 'VariablesFile',
        component: () => import('@/views/var/file/FileList.vue'),
        meta: {
          title: '变量文件'
        }
      },
      {
        path: '/variables/list',
        name: 'VariablesList',
        component: () => import('@/views/var/variables/Variables.vue'),
        meta: {
          title: '订单变量'
        }
      },
      {
        path: '/variables/change',
        name: 'VariablesChange',
        component: () => import('@/views/var/varChange/VarChange.vue'),
        meta: {
          title: '变量转换'
        }
      },
    ]
  },
  {
    path: '/email',
    name: 'Email',
    redirect: '/email/list',
    component: Layout,
    meta: {
      title: '邮件管理'
    },
    children: [
      {
        path: '/email/list',
        name: 'EmailList',
        component: () => import('@/views/email/EmailView.vue'),
        meta: {
          title: '邮件列表'
        }
      }
    ]
  },
  {
    path: '/product',
    name: 'Product',
    component: Layout,
    meta: {
      title: '产品管理'
    },
    children: [
      {
        path: '/product/list',
        name: 'ProductList',
        component: () => import('@/views/product/productList/ProductList.vue'),
        meta: {
          title: '产品列表'
        }
      },
      {
        path: '/product/compare',
        name: 'ProductCompare',
        component: () => import('@/views/product/productCompare/ProductCompare.vue'),
        meta: {
          title: '产品对照'
        }
      }
    ]
  },
  {
    path: '/online-excel',
    name: 'OnlineExcel',
    hidden: true,
    meta: {
      title: '订单上传'
    },
    component: () => import('@/views/excel/OnlineExcel2.vue')
  },
  {
    path: '/comment-excel',
    name: 'CommentExcel',
    hidden: true,
    meta: {
      title: '订单文件标注'
    },
    component: () => import('@/views/comment-excel/CommentExcel.vue')
  },
  {
    path: '/var-excel',
    name: 'VarExcel',
    hidden: true,
    meta: {
      title: '变量文件标注'
    },
    component: () => import('@/views/var/varExcel/CommentExcel.vue')
  },
  {
    path: '/comment-upload',
    name: 'CommentUpload',
    meta: {
      title: '订单上传'
    },
    component: () => import('@/views/comment-excel/CommentUpload.vue')
  },
  {
    path: '/var-upload',
    name: 'VarUpload',
    meta: {
      title: '变量上传'
    },
    component: () => import('@/views/var/varExcel/CommentUpload.vue')
  },
  {
    path: '/preview-excel',
    name: 'PreviewExcel',
    hidden: true,
    meta: {
      title: '预览'
    },
    component: () => import('@/views/order/preview/index.vue')
  }
]

const router = createRouter({
  history: createWebHistory(import.meta.env.BASE_URL),
  routes: [...baseRoutes, ...routes]
})

router.beforeEach((to, from, next) => {
  if (to.query.userId) {
    const userStore = useUserStore()
    userStore.setUserInfo(to.query.userId)

    next({
      replace: true,
      path: to.path
    })
  }

  next()
})

export function setupRouter(app: App) {
  app.use(router)
}

export default router
