import axios from '@/utils/http'
const formHeader = {
  'Content-Type': 'application/x-www-form-urlencoded;charset=UTF-8'
}

/**
 * 产品列表查询
 * @param params 
 * @returns 
 */
export const getProductList = (params: any) => {
  return axios.get('/api/product/list', {
    params,
    headers: formHeader
  })
}

/**
 * 新增产品
 * @param data 
 * @returns 
 */
export const saveProduct = (data: any) => {
    return axios.post('/api/product/add', data)
}

/**
 * 修改产品
 * @param data 
 * @returns 
 */
export const modifyProduct = (data: any) => {
    return axios.post('/api/product/edit', data)
}


/**
 * 获取产品类别树
 * @param params 
 * @returns 
 */
export const getProductCategoryTree = () => {
  return axios.get('/api/productCategory/tree', {
    headers: formHeader
  })
}

/**
 * 新增产品类别
 * @param data 
 * @returns 
 */
export const saveProductCategory = (data: any) => {
  return axios.post('/api/productCategory/add', data)
}

/**
 * 修改产品类别
 * @param data 
 * @returns 
 */
export const modifyProductCategory = (data: any) => {
  return axios.post('/api/productCategory/edit', data)
}

/**
 * 批量删除产品类别
 * @param ids 
 * @returns 
 */
export const deleteProductCategorys = (ids: string) => {
  return axios.get('/api/productCategory/batchDeleteByIds', {
    params: { ids },
    headers: formHeader
  })
}

/**
 * 获取产品对照列表
 * @param params 
 * @returns 
 */
export const getExcelProdFileConfPage = (params: any) => {
  return axios.get('/api/excelProductFileConf/page', {
    params,
    headers: formHeader
  })
}

/**
 * 新增产品对照
 * @param data 
 * @returns 
 */
export const saveExcelProdFileConf = (data: any) => {
  return axios.post('/api/excelProductFileConf/add', data)
}
/**
 * 修改产品对照
 * @param data 
 * @returns 
 */
export const editExcelProdFileConf = (data: any) => {
  return axios.post('/api/excelProductFileConf/edit', data)
}

export const deleteExcelProdFileConfByIds = (ids: string) => {
  return axios.get('/api/excelProductFileConf/batchDeleteByIds', {
    params: {ids},
    headers: formHeader
  })
}