import type { Recordable } from '@/types/global'
import { defineStore } from 'pinia'

type StoreState = {
  userId: string
}
export const useUserStore = defineStore('userStore', {
  state: (): StoreState => ({
    userId: ''
  }),
  getters: {
    getUserInfo(): string {
      return this.userId
    }
  },
  actions: {
    setUserInfo(id: any) {
      this.userId = id
    }
  },persist: true
})
