import type { Recordable } from '@/types/global'

/**
 * 处理查询参数模糊查询
 * @param params
 * @param field
 */
export function queryParamsFilter(params: Recordable, field?: string[]) {
  const exclude = ['currentPage', 'pageSize', 'total', 'column', 'order'].concat(field || [])
  const p = Object.assign({}, params)

  for (const key in params) {
    if (!exclude.includes(key)) {
      p[key] = `*${p[key]}*`
    }
  }

  return p
}
