import * as XLSX from 'xlsx'
import { saveAs } from 'file-saver'

export function exportExcel(data: any[], filename?: string) {
  data.forEach(row => {
    delete row['_X_ROW_KEY']
  })
  const worksheet = XLSX.utils.json_to_sheet(data)

  const workbook = XLSX.utils.book_new()

  XLSX.utils.book_append_sheet(workbook, worksheet, 'Sheet1')

  const excelBuffer = XLSX.write(workbook, { bookType: 'xlsx', type: 'array' })

  const blob = new Blob([excelBuffer], { type: 'application/octet-stream' })

  saveAs(blob, filename || '数据导出.xlsx')
}
