import './assets/main.css'
import './assets/tailwind.css'
import 'element-plus/dist/index.css'
import 'vxe-table/lib/style.css'

import { createApp } from 'vue'

import App from './App.vue'
import ElementPlus from 'element-plus'
import VXETable from 'vxe-table'

import { setupRouter } from './router'
import { setupStore } from './stores'
import { zhCn } from 'element-plus/es/locales.mjs'


function bootstrap() {
  const app = createApp(App)

  setupStore(app)

  setupRouter(app)

  app.use(ElementPlus, {locale: zhCn})
  app.use(VXETable)

  app.mount('#app')
}

bootstrap()
