import axios from '@/utils/http'

const formHeader = {
  'Content-Type': 'application/x-www-form-urlencoded;charset=UTF-8'
}

/**
 * 上传文件确认，多文件合并
 * @param {Object} data
 * @returns
 */
export const apiSaveUpload = (data: any) => {
  return axios.post('/api/varFile/saveUpload', data)
}

export const addExcelArea = (data: any) => {
  return axios.post('/api/varFile/addVarArea', data)
}
export const editExcelArea = (data: any) => {
  return axios.post('/api/varFile/editVarArea', data)
}

export const getExcelAreaByFileId = (orderFileId: string) => {
  return axios.get('/api/varFile/getVarAreaByFileID', {
    params: { orderFileId },
    headers: formHeader
  })
}
export const removeExcelArea = (varAreaId: string) => {
  return axios.get('/api/varFile/removeVarArea', {
    params: { varAreaId },
    headers: formHeader
  })
}
export const getExcelConnectByFileId = (orderFileId: string) => {
  return axios.get('/api/varFile/getVarAreaConnectByFileID', {
    params: { orderFileId },
    headers: formHeader
  })
}
export const removeExcelAreaConnect = (varAreaConnectId: string) => {
  return axios.get('/api/varFile/removeVarAreaConnect', {
    params: { varAreaConnectId },
    headers: formHeader
  })
}
export const addExcelAreaConnect = (data: any) => {
  return axios.post('/api/varFile/addVarAreaConnect', data)
}
export const excelMarkRun = (varFileId: string) => {
  return axios.get('/api/varFile/runTemplate', {
    params: { varFileId },
    headers: formHeader
  })
}

