import axios from '@/utils/http'

const formHeader = {
  'Content-Type': 'application/x-www-form-urlencoded;charset=UTF-8'
}

export const getOrderFilePage = (params: any) => {
  return axios.get('/api/excelOrderFile/page', {
    params,
    headers: formHeader
  })
}

export const getPageMarkFile = (params: any) => {
  return axios.get('/api/excelOrderFile/pageMarkFile', {
    params,
    headers: formHeader
  })
}

export const deleteOrderFiles = (ids: string) => {
  return axios.get('/api/excelOrderFile/batchDeleteByIds', {
    params: { ids },
    headers: formHeader
  })
}

export const getOrderFileById = (id: string) => {
  return axios.get('/api/excelOrderFile/getById', {
    params: { id },
    headers: formHeader
  })
}

export const modifyCustomerEmail = (data: any) => {
  return axios.post('/api/customer/editEmail', data)
}

export const saveCustomerEmail = (data: any) => {
  return axios.post('/api/customer/addEmail', data)
}

export const getCustomerEmailList = (params: any) => {
  return axios.get('/api/customer/listEmail', {
    params,
    headers: formHeader
  })
}

export const deleteCustomerEmails = (customerEmailIds: string) => {
  return axios.get('/api/customer/deleteEmailByIds', {
    params: { customerEmailIds },
    headers: formHeader
  })
}

/** excel文件解析列表 */
export const getExcelFileOrderPage = (params: any) => {
  return axios.get('/api/excelFileOrder/page', {
    params,
    headers: formHeader
  })
}

/** 设置订单字段 */
export const saveConfExcelFileOrderPage = (data: any) => {
  return axios.post('/api/excelFileOrder/saveConf', data)
}

/** 批量删除 */
export const deleteExcelFileOrderById = (ids: any) => {
  return axios.get('/api/excelFileOrder/batchDeleteByIds', {
    params: { ids },
    headers: formHeader
  })
}

/** 转换订单 */
export const convertExcelFileOrder = (excelOrderId: string) => {
  return axios.get('/api/excelFileOrder/convert', {
    params: { excelOrderId },
    headers: formHeader
  })
}

/** 解析后确认订单 */
export const unconvertExcelFileOrder = (excelOrderId: string) => {
  return axios.get('/api/excelFileOrder/unconvert', {
    params: { excelOrderId },
    headers: formHeader
  })
}

/** 转换后确认订单 */
export const confirmExcelFileOrderById = (excelOrderId: string) => {
  return axios.get('/api/excelFileOrder/confirmById', {
    params: { excelOrderId },
    headers: formHeader
  })
}

/** 根据订单文件获取订单字段配置 */
export const getConfByExcelOrderId = (excelOrderId: string) => {
  return axios.get('/api/excelFileOrder/getConfByExcelOrderId', {
    params: { excelOrderId },
    headers: formHeader
  })
}

/** 转换订单记录 */
export const convertOrderPage = (params: any) => {
  return axios.get('/api/convertOrder/page', {
    params,
    headers: formHeader
  })
}

/** 批量删除记录 */
export const convertOrderBatchDeleteById = (ids: any) => {
  return axios.get('/api/convertOrder/batchDeleteById', {
    params: { ids },
    headers: formHeader
  })
}

/** 订单重发 */
export const convertOrderReSend = (id: any) => {
  return axios.get('/api/convertOrder/reSend', {
    params: { id },
    headers: formHeader
  })
}

/** 导入 */
export const excelFileOrderImportExcel = (params: any) => {
  return axios.get('/api/excelFileOrder/importExcel', {
    params,
    headers: formHeader
  })
}

/** 导出 */
export const excelFileOrderExportExcel = (excelOrderId: any) => {
  return axios.post(
    '/api/excelFileOrder/exportExcel',
    {},
    {
      params: { excelOrderId },
      headers: formHeader,
      responseType: 'blob'
    }
  )
}
